/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.citationkeypattern;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableKeyChange;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class GenerateCitationKeyAction
extends SimpleCommand {
    private final Supplier<LibraryTab> tabSupplier;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private List<BibEntry> entries;
    private boolean isCanceled;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferencesService;
    private final UndoManager undoManager;

    public GenerateCitationKeyAction(Supplier<LibraryTab> tabSupplier, DialogService dialogService, StateManager stateManager, TaskExecutor taskExecutor, PreferencesService preferencesService, UndoManager undoManager) {
        this.tabSupplier = tabSupplier;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.taskExecutor = taskExecutor;
        this.preferencesService = preferencesService;
        this.undoManager = undoManager;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        this.entries = this.stateManager.getSelectedEntries();
        if (this.entries.isEmpty()) {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Autogenerate citation keys", new Object[0]), Localization.lang("First select the entries you want keys to be generated for.", new Object[0]));
            return;
        }
        this.dialogService.notify(this.formatOutputMessage(Localization.lang("Generating citation key for", new Object[0]), this.entries.size()));
        this.checkOverwriteKeysChosen();
        if (!this.isCanceled) {
            BackgroundTask<Void> backgroundTask = this.generateKeysInBackground();
            backgroundTask.showToUser(true);
            backgroundTask.titleProperty().set((Object)Localization.lang("Autogenerate citation keys", new Object[0]));
            backgroundTask.messageProperty().set((Object)Localization.lang("%0/%1 entries", 0, this.entries.size()));
            backgroundTask.executeWith(this.taskExecutor);
        }
    }

    public static boolean confirmOverwriteKeys(DialogService dialogService, PreferencesService preferencesService) {
        if (preferencesService.getCitationKeyPatternPreferences().shouldWarnBeforeOverwriteCiteKey()) {
            return dialogService.showConfirmationDialogWithOptOutAndWait(Localization.lang("Overwrite keys", new Object[0]), Localization.lang("One or more keys will be overwritten. Continue?", new Object[0]), Localization.lang("Overwrite keys", new Object[0]), Localization.lang("Cancel", new Object[0]), Localization.lang("Do not ask again", new Object[0]), optOut -> preferencesService.getCitationKeyPatternPreferences().setWarnBeforeOverwriteCiteKey(optOut == false));
        }
        return true;
    }

    private void checkOverwriteKeysChosen() {
        boolean overwriteKeys;
        if (this.preferencesService.getCitationKeyPatternPreferences().shouldAvoidOverwriteCiteKey()) {
            this.entries.removeIf(BibEntry::hasCitationKey);
        } else if (this.entries.parallelStream().anyMatch(BibEntry::hasCitationKey) && !(overwriteKeys = GenerateCitationKeyAction.confirmOverwriteKeys(this.dialogService, this.preferencesService))) {
            this.isCanceled = true;
        }
    }

    private BackgroundTask<Void> generateKeysInBackground() {
        return new BackgroundTask<Void>(){
            private NamedCompound compound;

            @Override
            protected Void call() {
                if (GenerateCitationKeyAction.this.isCanceled) {
                    return null;
                }
                UiTaskExecutor.runInJavaFXThread(() -> {
                    this.updateProgress(0.0, GenerateCitationKeyAction.this.entries.size());
                    this.messageProperty().set((Object)Localization.lang("%0/%1 entries", 0, GenerateCitationKeyAction.this.entries.size()));
                });
                GenerateCitationKeyAction.this.stateManager.getActiveDatabase().ifPresent(databaseContext -> {
                    this.compound = new NamedCompound(Localization.lang("Autogenerate citation keys", new Object[0]));
                    CitationKeyGenerator keyGenerator = new CitationKeyGenerator((BibDatabaseContext)databaseContext, GenerateCitationKeyAction.this.preferencesService.getCitationKeyPatternPreferences());
                    int entriesDone = 0;
                    for (BibEntry entry : GenerateCitationKeyAction.this.entries) {
                        keyGenerator.generateAndSetKey(entry).ifPresent(fieldChange -> this.compound.addEdit(new UndoableKeyChange((FieldChange)fieldChange)));
                        int finalEntriesDone = ++entriesDone;
                        UiTaskExecutor.runInJavaFXThread(() -> {
                            this.updateProgress(finalEntriesDone, GenerateCitationKeyAction.this.entries.size());
                            this.messageProperty().set((Object)Localization.lang("%0/%1 entries", finalEntriesDone, GenerateCitationKeyAction.this.entries.size()));
                        });
                    }
                    this.compound.end();
                });
                return null;
            }

            @Override
            public BackgroundTask<Void> onSuccess(Consumer<Void> onSuccess) {
                if (this.compound.hasEdits()) {
                    GenerateCitationKeyAction.this.undoManager.addEdit(this.compound);
                }
                GenerateCitationKeyAction.this.tabSupplier.get().markBaseChanged();
                GenerateCitationKeyAction.this.dialogService.notify(GenerateCitationKeyAction.this.formatOutputMessage(Localization.lang("Generated citation key for", new Object[0]), GenerateCitationKeyAction.this.entries.size()));
                return super.onSuccess(onSuccess);
            }
        };
    }

    private String formatOutputMessage(String start, int count) {
        return "%s %d %s.".formatted(start, count, count > 1 ? Localization.lang("entries", new Object[0]) : Localization.lang("entry", new Object[0]));
    }
}

