/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.EnumSet;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.gui.autocompleter.BibEntrySuggestionProvider;
import org.jabref.gui.autocompleter.EmptySuggestionProvider;
import org.jabref.gui.autocompleter.JournalsSuggestionProvider;
import org.jabref.gui.autocompleter.PersonNameSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.autocompleter.WordSuggestionProvider;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.StandardField;

public class SuggestionProviders {
    private final boolean isEmpty;
    private BibDatabase database;
    private JournalAbbreviationRepository abbreviationRepository;
    private AutoCompletePreferences autoCompletePreferences;

    public SuggestionProviders(BibDatabase database, JournalAbbreviationRepository abbreviationRepository, AutoCompletePreferences autoCompletePreferences) {
        this.database = database;
        this.abbreviationRepository = abbreviationRepository;
        this.autoCompletePreferences = autoCompletePreferences;
        this.isEmpty = false;
    }

    public SuggestionProviders() {
        this.isEmpty = true;
    }

    public SuggestionProvider<?> getForField(Field field) {
        if (this.isEmpty || !this.autoCompletePreferences.getCompleteFields().contains((Object)field)) {
            return new EmptySuggestionProvider();
        }
        EnumSet<FieldProperty> fieldProperties = field.getProperties();
        if (fieldProperties.contains((Object)FieldProperty.PERSON_NAMES)) {
            return new PersonNameSuggestionProvider(field, this.database);
        }
        if (fieldProperties.contains((Object)FieldProperty.SINGLE_ENTRY_LINK) || fieldProperties.contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK)) {
            return new BibEntrySuggestionProvider(this.database);
        }
        if (fieldProperties.contains((Object)FieldProperty.JOURNAL_NAME) || StandardField.PUBLISHER == field) {
            return new JournalsSuggestionProvider(field, this.database, this.abbreviationRepository);
        }
        return new WordSuggestionProvider(field, this.database);
    }
}

