/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.jabref.gui.autocompleter.AutoCompleteFirstNameMode;
import org.jabref.model.entry.field.Field;

public class AutoCompletePreferences {
    private final BooleanProperty shouldAutoComplete;
    private final ObjectProperty<AutoCompleteFirstNameMode> firstNameMode;
    private final ObjectProperty<NameFormat> nameFormat;
    private final ObservableSet<Field> completeFields;

    public AutoCompletePreferences(boolean shouldAutoComplete, AutoCompleteFirstNameMode firstNameMode, NameFormat nameFormat, Set<Field> completeFields) {
        this.shouldAutoComplete = new SimpleBooleanProperty(shouldAutoComplete);
        this.firstNameMode = new SimpleObjectProperty((Object)firstNameMode);
        this.nameFormat = new SimpleObjectProperty((Object)nameFormat);
        this.completeFields = FXCollections.observableSet(completeFields);
    }

    public boolean shouldAutoComplete() {
        return this.shouldAutoComplete.get();
    }

    public BooleanProperty autoCompleteProperty() {
        return this.shouldAutoComplete;
    }

    public void setAutoComplete(boolean shouldAutoComplete) {
        this.shouldAutoComplete.set(shouldAutoComplete);
    }

    public AutoCompleteFirstNameMode getFirstNameMode() {
        return (AutoCompleteFirstNameMode)((Object)this.firstNameMode.get());
    }

    public ObjectProperty<AutoCompleteFirstNameMode> firstNameModeProperty() {
        return this.firstNameMode;
    }

    public void setFirstNameMode(AutoCompleteFirstNameMode firstNameMode) {
        this.firstNameMode.set((Object)firstNameMode);
    }

    public NameFormat getNameFormat() {
        return (NameFormat)((Object)this.nameFormat.get());
    }

    public ObjectProperty<NameFormat> nameFormatProperty() {
        return this.nameFormat;
    }

    public void setNameFormat(NameFormat nameFormat) {
        this.nameFormat.set((Object)nameFormat);
    }

    public ObservableSet<Field> getCompleteFields() {
        return this.completeFields;
    }

    public static enum NameFormat {
        LAST_FIRST,
        FIRST_LAST,
        BOTH;

    }
}

