/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.util.Objects;
import java.util.Optional;
import org.jabref.gui.actions.Action;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.l10n.Localization;

public enum StandardActions implements Action
{
    COPY_MORE(Localization.lang("Copy", new Object[0]) + "..."),
    COPY_TITLE(Localization.lang("Copy title", new Object[0]), KeyBinding.COPY_TITLE),
    COPY_KEY(Localization.lang("Copy citation key", new Object[0]), KeyBinding.COPY_CITATION_KEY),
    COPY_CITE_KEY(Localization.lang("Copy citation key with configured cite command", new Object[0]), KeyBinding.COPY_CITE_CITATION_KEY),
    COPY_KEY_AND_TITLE(Localization.lang("Copy citation key and title", new Object[0]), KeyBinding.COPY_CITATION_KEY_AND_TITLE),
    COPY_KEY_AND_LINK(Localization.lang("Copy citation key and link", new Object[0]), KeyBinding.COPY_CITATION_KEY_AND_LINK),
    COPY_CITATION_HTML(Localization.lang("Copy citation (html)", new Object[0]), KeyBinding.COPY_PREVIEW),
    COPY_CITATION_TEXT(Localization.lang("Copy citation (text)", new Object[0])),
    COPY_CITATION_PREVIEW(Localization.lang("Copy preview", new Object[0]), KeyBinding.COPY_PREVIEW),
    EXPORT_TO_CLIPBOARD(Localization.lang("Export to clipboard", new Object[0]), IconTheme.JabRefIcons.EXPORT_TO_CLIPBOARD),
    EXPORT_SELECTED_TO_CLIPBOARD(Localization.lang("Export selected entries to clipboard", new Object[0]), IconTheme.JabRefIcons.EXPORT_TO_CLIPBOARD),
    COPY(Localization.lang("Copy", new Object[0]), IconTheme.JabRefIcons.COPY, KeyBinding.COPY),
    PASTE(Localization.lang("Paste", new Object[0]), IconTheme.JabRefIcons.PASTE, KeyBinding.PASTE),
    CUT(Localization.lang("Cut", new Object[0]), IconTheme.JabRefIcons.CUT, KeyBinding.CUT),
    DELETE(Localization.lang("Delete", new Object[0]), IconTheme.JabRefIcons.DELETE_ENTRY),
    DELETE_ENTRY(Localization.lang("Delete entry", new Object[0]), IconTheme.JabRefIcons.DELETE_ENTRY, KeyBinding.DELETE_ENTRY),
    SEND(Localization.lang("Send", new Object[0]), IconTheme.JabRefIcons.EMAIL),
    SEND_AS_EMAIL(Localization.lang("As Email", new Object[0])),
    SEND_TO_KINDLE(Localization.lang("To Kindle", new Object[0])),
    REBUILD_FULLTEXT_SEARCH_INDEX(Localization.lang("Rebuild fulltext search index", new Object[0]), IconTheme.JabRefIcons.FILE),
    REDOWNLOAD_MISSING_FILES(Localization.lang("Redownload missing files", new Object[0]), IconTheme.JabRefIcons.DOWNLOAD),
    OPEN_EXTERNAL_FILE(Localization.lang("Open file", new Object[0]), IconTheme.JabRefIcons.FILE, KeyBinding.OPEN_FILE),
    EXTRACT_FILE_REFERENCES_ONLINE(Localization.lang("Extract references from file (online)", new Object[0]), IconTheme.JabRefIcons.FILE_STAR),
    EXTRACT_FILE_REFERENCES_OFFLINE(Localization.lang("Extract references from file (offline)", new Object[0]), IconTheme.JabRefIcons.FILE_STAR),
    OPEN_URL(Localization.lang("Open URL or DOI", new Object[0]), IconTheme.JabRefIcons.WWW, KeyBinding.OPEN_URL_OR_DOI),
    SEARCH_SHORTSCIENCE(Localization.lang("Search ShortScience", new Object[0])),
    MERGE_WITH_FETCHED_ENTRY(Localization.lang("Get bibliographic data from %0", "DOI/ISBN/...")),
    ATTACH_FILE(Localization.lang("Attach file", new Object[0]), IconTheme.JabRefIcons.ATTACH_FILE),
    ATTACH_FILE_FROM_URL(Localization.lang("Attach file from URL", new Object[0]), IconTheme.JabRefIcons.DOWNLOAD_FILE),
    PRIORITY(Localization.lang("Priority", new Object[0]), IconTheme.JabRefIcons.PRIORITY),
    CLEAR_PRIORITY(Localization.lang("Clear priority", new Object[0])),
    PRIORITY_HIGH(Localization.lang("Set priority to high", new Object[0]), IconTheme.JabRefIcons.PRIORITY_HIGH),
    PRIORITY_MEDIUM(Localization.lang("Set priority to medium", new Object[0]), IconTheme.JabRefIcons.PRIORITY_MEDIUM),
    PRIORITY_LOW(Localization.lang("Set priority to low", new Object[0]), IconTheme.JabRefIcons.PRIORITY_LOW),
    QUALITY(Localization.lang("Quality", new Object[0]), IconTheme.JabRefIcons.QUALITY),
    QUALITY_ASSURED(Localization.lang("Toggle quality assured", new Object[0]), IconTheme.JabRefIcons.QUALITY_ASSURED),
    RANKING(Localization.lang("Rank", new Object[0]), IconTheme.JabRefIcons.RANKING),
    CLEAR_RANK(Localization.lang("Clear rank", new Object[0])),
    RANK_1(Localization.lang("Set rank to one", new Object[0]), IconTheme.JabRefIcons.RANK1),
    RANK_2(Localization.lang("Set rank to two", new Object[0]), IconTheme.JabRefIcons.RANK2),
    RANK_3(Localization.lang("Set rank to three", new Object[0]), IconTheme.JabRefIcons.RANK3),
    RANK_4(Localization.lang("Set rank to four", new Object[0]), IconTheme.JabRefIcons.RANK4),
    RANK_5(Localization.lang("Set rank to five", new Object[0]), IconTheme.JabRefIcons.RANK5),
    PRINTED(Localization.lang("Printed", new Object[0]), IconTheme.JabRefIcons.PRINTED),
    TOGGLE_PRINTED(Localization.lang("Toggle print status", new Object[0]), IconTheme.JabRefIcons.PRINTED),
    READ_STATUS(Localization.lang("Read status", new Object[0]), IconTheme.JabRefIcons.READ_STATUS),
    CLEAR_READ_STATUS(Localization.lang("Clear read status", new Object[0]), KeyBinding.CLEAR_READ_STATUS),
    READ(Localization.lang("Set read status to read", new Object[0]), IconTheme.JabRefIcons.READ_STATUS_READ, KeyBinding.READ),
    SKIMMED(Localization.lang("Set read status to skimmed", new Object[0]), IconTheme.JabRefIcons.READ_STATUS_SKIMMED, KeyBinding.SKIMMED),
    RELEVANCE(Localization.lang("Relevance", new Object[0]), IconTheme.JabRefIcons.RELEVANCE),
    RELEVANT(Localization.lang("Toggle relevance", new Object[0]), IconTheme.JabRefIcons.RELEVANCE),
    NEW_LIBRARY(Localization.lang("New library", new Object[0]), IconTheme.JabRefIcons.NEW),
    OPEN_LIBRARY(Localization.lang("Open library", new Object[0]), IconTheme.JabRefIcons.OPEN, KeyBinding.OPEN_DATABASE),
    IMPORT(Localization.lang("Import", new Object[0]), IconTheme.JabRefIcons.IMPORT),
    EXPORT(Localization.lang("Export", new Object[0]), IconTheme.JabRefIcons.EXPORT, KeyBinding.EXPORT),
    SAVE_LIBRARY(Localization.lang("Save library", new Object[0]), IconTheme.JabRefIcons.SAVE, KeyBinding.SAVE_DATABASE),
    SAVE_LIBRARY_AS(Localization.lang("Save library as...", new Object[0]), KeyBinding.SAVE_DATABASE_AS),
    SAVE_SELECTED_AS_PLAIN_BIBTEX(Localization.lang("Save selected as plain BibTeX...", new Object[0])),
    SAVE_ALL(Localization.lang("Save all", new Object[0]), Localization.lang("Save all open libraries", new Object[0]), IconTheme.JabRefIcons.SAVE_ALL, KeyBinding.SAVE_ALL),
    IMPORT_INTO_NEW_LIBRARY(Localization.lang("Import into new library", new Object[0]), KeyBinding.IMPORT_INTO_NEW_DATABASE),
    IMPORT_INTO_CURRENT_LIBRARY(Localization.lang("Import into current library", new Object[0]), KeyBinding.IMPORT_INTO_CURRENT_DATABASE),
    EXPORT_ALL(Localization.lang("Export all entries", new Object[0])),
    REMOTE_DB(Localization.lang("Shared database", new Object[0]), IconTheme.JabRefIcons.REMOTE_DATABASE),
    EXPORT_SELECTED(Localization.lang("Export selected entries", new Object[0]), KeyBinding.EXPORT_SELECTED),
    CONNECT_TO_SHARED_DB(Localization.lang("Connect to shared database", new Object[0]), IconTheme.JabRefIcons.CONNECT_DB),
    PULL_CHANGES_FROM_SHARED_DB(Localization.lang("Pull changes from shared database", new Object[0]), KeyBinding.PULL_CHANGES_FROM_SHARED_DATABASE),
    CLOSE_LIBRARY(Localization.lang("Close library", new Object[0]), Localization.lang("Close the current library", new Object[0]), IconTheme.JabRefIcons.CLOSE, KeyBinding.CLOSE_DATABASE),
    CLOSE_OTHER_LIBRARIES(Localization.lang("Close others", new Object[0]), Localization.lang("Close other libraries", new Object[0]), IconTheme.JabRefIcons.CLOSE),
    CLOSE_ALL_LIBRARIES(Localization.lang("Close all", new Object[0]), Localization.lang("Close all libraries", new Object[0]), IconTheme.JabRefIcons.CLOSE),
    QUIT(Localization.lang("Quit", new Object[0]), Localization.lang("Quit JabRef", new Object[0]), IconTheme.JabRefIcons.CLOSE_JABREF, KeyBinding.QUIT_JABREF),
    UNDO(Localization.lang("Undo", new Object[0]), IconTheme.JabRefIcons.UNDO, KeyBinding.UNDO),
    REDO(Localization.lang("Redo", new Object[0]), IconTheme.JabRefIcons.REDO, KeyBinding.REDO),
    REPLACE_ALL(Localization.lang("Find and replace", new Object[0]), KeyBinding.REPLACE_STRING),
    MANAGE_KEYWORDS(Localization.lang("Manage keywords", new Object[0])),
    MASS_SET_FIELDS(Localization.lang("Manage field names & content", new Object[0])),
    AUTOMATIC_FIELD_EDITOR(Localization.lang("Automatic field editor", new Object[0])),
    TOGGLE_GROUPS(Localization.lang("Groups", new Object[0]), IconTheme.JabRefIcons.TOGGLE_GROUPS, KeyBinding.TOGGLE_GROUPS_INTERFACE),
    TOGGLE_OO(Localization.lang("OpenOffice/LibreOffice", new Object[0]), IconTheme.JabRefIcons.FILE_OPENOFFICE, KeyBinding.OPEN_OPEN_OFFICE_LIBRE_OFFICE_CONNECTION),
    TOGGLE_WEB_SEARCH(Localization.lang("Web search", new Object[0]), Localization.lang("Toggle web search interface", new Object[0]), IconTheme.JabRefIcons.WWW, KeyBinding.WEB_SEARCH),
    PARSE_LATEX(Localization.lang("Search for citations in LaTeX files...", new Object[0]), IconTheme.JabRefIcons.LATEX_CITATIONS),
    NEW_SUB_LIBRARY_FROM_AUX(Localization.lang("New sublibrary based on AUX file", new Object[0]) + "...", Localization.lang("New BibTeX sublibrary", new Object[0]) + Localization.lang("This feature generates a new library based on which entries are needed in an existing LaTeX document.", new Object[0]), IconTheme.JabRefIcons.NEW),
    WRITE_METADATA_TO_PDF(Localization.lang("Write metadata to PDF files", new Object[0]), Localization.lang("Will write metadata to the PDFs linked from selected entries.", new Object[0]), KeyBinding.WRITE_METADATA_TO_PDF),
    START_NEW_STUDY(Localization.lang("Start new systematic literature review", new Object[0])),
    UPDATE_SEARCH_RESULTS_OF_STUDY(Localization.lang("Update study search results", new Object[0])),
    EDIT_EXISTING_STUDY(Localization.lang("Manage study definition", new Object[0])),
    OPEN_DATABASE_FOLDER(Localization.lang("Reveal in file explorer", new Object[0])),
    OPEN_FOLDER(Localization.lang("Open folder", new Object[0]), Localization.lang("Open folder", new Object[0]), IconTheme.JabRefIcons.FOLDER, KeyBinding.OPEN_FOLDER),
    OPEN_FILE(Localization.lang("Open file", new Object[0]), Localization.lang("Open file", new Object[0]), IconTheme.JabRefIcons.FILE, KeyBinding.OPEN_FILE),
    OPEN_CONSOLE(Localization.lang("Open terminal here", new Object[0]), Localization.lang("Open terminal here", new Object[0]), IconTheme.JabRefIcons.CONSOLE, KeyBinding.OPEN_CONSOLE),
    COPY_LINKED_FILES(Localization.lang("Copy linked files to folder...", new Object[0])),
    COPY_DOI(Localization.lang("Copy DOI", new Object[0])),
    COPY_DOI_URL(Localization.lang("Copy DOI url", new Object[0])),
    ABBREVIATE(Localization.lang("Abbreviate journal names", new Object[0])),
    ABBREVIATE_DEFAULT(Localization.lang("default", new Object[0]), Localization.lang("Abbreviate journal names of the selected entries (DEFAULT abbreviation)", new Object[0]), KeyBinding.ABBREVIATE),
    ABBREVIATE_DOTLESS(Localization.lang("dotless", new Object[0]), Localization.lang("Abbreviate journal names of the selected entries (DOTLESS abbreviation)", new Object[0])),
    ABBREVIATE_SHORTEST_UNIQUE(Localization.lang("shortest unique", new Object[0]), Localization.lang("Abbreviate journal names of the selected entries (SHORTEST UNIQUE abbreviation)", new Object[0])),
    UNABBREVIATE(Localization.lang("Unabbreviate journal names", new Object[0]), Localization.lang("Unabbreviate journal names of the selected entries", new Object[0]), KeyBinding.UNABBREVIATE),
    MANAGE_CUSTOM_EXPORTS(Localization.lang("Manage custom exports", new Object[0])),
    MANAGE_CUSTOM_IMPORTS(Localization.lang("Manage custom imports", new Object[0])),
    CUSTOMIZE_ENTRY_TYPES(Localization.lang("Customize entry types", new Object[0])),
    SETUP_GENERAL_FIELDS(Localization.lang("Set up general fields", new Object[0])),
    MANAGE_PROTECTED_TERMS(Localization.lang("Manage protected terms", new Object[0])),
    CITATION_KEY_PATTERN(Localization.lang("Citation key patterns", new Object[0])),
    SHOW_PREFS(Localization.lang("Preferences", new Object[0]), IconTheme.JabRefIcons.PREFERENCES, KeyBinding.SHOW_PREFS),
    MANAGE_JOURNALS(Localization.lang("Manage journal abbreviations", new Object[0])),
    CUSTOMIZE_KEYBINDING(Localization.lang("Customize keyboard shortcuts", new Object[0]), IconTheme.JabRefIcons.KEY_BINDINGS),
    EDIT_ENTRY(Localization.lang("Open entry editor", new Object[0]), IconTheme.JabRefIcons.EDIT_ENTRY, KeyBinding.OPEN_CLOSE_ENTRY_EDITOR),
    SHOW_PDF_VIEWER(Localization.lang("Open document viewer", new Object[0]), IconTheme.JabRefIcons.PDF_FILE),
    NEXT_PREVIEW_STYLE(Localization.lang("Next preview style", new Object[0]), KeyBinding.NEXT_PREVIEW_LAYOUT),
    PREVIOUS_PREVIEW_STYLE(Localization.lang("Previous preview style", new Object[0]), KeyBinding.PREVIOUS_PREVIEW_LAYOUT),
    SELECT_ALL(Localization.lang("Select all", new Object[0]), KeyBinding.SELECT_ALL),
    UNSELECT_ALL(Localization.lang("Unselect all", new Object[0])),
    EXPAND_ALL(Localization.lang("Expand all", new Object[0])),
    COLLAPSE_ALL(Localization.lang("Collapse all", new Object[0])),
    NEW_ENTRY(Localization.lang("New entry", new Object[0]), IconTheme.JabRefIcons.ADD_ENTRY, KeyBinding.NEW_ENTRY),
    NEW_ARTICLE(Localization.lang("New article", new Object[0]), IconTheme.JabRefIcons.ADD_ARTICLE),
    NEW_ENTRY_FROM_PLAIN_TEXT(Localization.lang("New entry from plain text", new Object[0]), IconTheme.JabRefIcons.NEW_ENTRY_FROM_PLAIN_TEXT, KeyBinding.NEW_ENTRY_FROM_PLAIN_TEXT),
    LIBRARY_PROPERTIES(Localization.lang("Library properties", new Object[0])),
    FIND_DUPLICATES(Localization.lang("Find duplicates", new Object[0]), IconTheme.JabRefIcons.FIND_DUPLICATES),
    MERGE_ENTRIES(Localization.lang("Merge entries", new Object[0]), IconTheme.JabRefIcons.MERGE_ENTRIES, KeyBinding.MERGE_ENTRIES),
    RESOLVE_DUPLICATE_KEYS(Localization.lang("Resolve duplicate citation keys", new Object[0]), Localization.lang("Find and remove duplicate citation keys", new Object[0]), KeyBinding.RESOLVE_DUPLICATE_CITATION_KEYS),
    CHECK_INTEGRITY(Localization.lang("Check integrity", new Object[0]), KeyBinding.CHECK_INTEGRITY),
    FIND_UNLINKED_FILES(Localization.lang("Search for unlinked local files", new Object[0]), IconTheme.JabRefIcons.SEARCH, KeyBinding.FIND_UNLINKED_FILES),
    AUTO_LINK_FILES(Localization.lang("Automatically set file links", new Object[0]), IconTheme.JabRefIcons.AUTO_FILE_LINK, KeyBinding.AUTOMATICALLY_LINK_FILES),
    LOOKUP_DOC_IDENTIFIER(Localization.lang("Search document identifier online", new Object[0])),
    LOOKUP_FULLTEXT(Localization.lang("Search full text documents online", new Object[0]), IconTheme.JabRefIcons.FILE_SEARCH, KeyBinding.DOWNLOAD_FULL_TEXT),
    GENERATE_CITE_KEY(Localization.lang("Generate citation key", new Object[0]), IconTheme.JabRefIcons.MAKE_KEY, KeyBinding.AUTOGENERATE_CITATION_KEYS),
    GENERATE_CITE_KEYS(Localization.lang("Generate citation keys", new Object[0]), IconTheme.JabRefIcons.MAKE_KEY, KeyBinding.AUTOGENERATE_CITATION_KEYS),
    DOWNLOAD_FULL_TEXT(Localization.lang("Search full text documents online", new Object[0]), IconTheme.JabRefIcons.FILE_SEARCH, KeyBinding.DOWNLOAD_FULL_TEXT),
    CLEANUP_ENTRIES(Localization.lang("Cleanup entries", new Object[0]), IconTheme.JabRefIcons.CLEANUP_ENTRIES, KeyBinding.CLEANUP),
    SET_FILE_LINKS(Localization.lang("Automatically set file links", new Object[0]), KeyBinding.AUTOMATICALLY_LINK_FILES),
    EDIT_FILE_LINK(Localization.lang("Edit", new Object[0]), IconTheme.JabRefIcons.EDIT, KeyBinding.OPEN_CLOSE_ENTRY_EDITOR),
    DOWNLOAD_FILE(Localization.lang("Download file", new Object[0]), IconTheme.JabRefIcons.DOWNLOAD_FILE),
    REDOWNLOAD_FILE(Localization.lang("Redownload file", new Object[0]), IconTheme.JabRefIcons.DOWNLOAD_FILE),
    RENAME_FILE_TO_PATTERN(Localization.lang("Rename file to defined pattern", new Object[0]), IconTheme.JabRefIcons.AUTO_RENAME),
    RENAME_FILE_TO_NAME(Localization.lang("Rename file to a given name", new Object[0]), IconTheme.JabRefIcons.RENAME, KeyBinding.REPLACE_STRING),
    MOVE_FILE_TO_FOLDER(Localization.lang("Move file to file directory", new Object[0]), IconTheme.JabRefIcons.MOVE_TO_FOLDER),
    MOVE_FILE_TO_FOLDER_AND_RENAME(Localization.lang("Move file to file directory and rename file", new Object[0])),
    COPY_FILE_TO_FOLDER(Localization.lang("Copy linked file to folder...", new Object[0]), IconTheme.JabRefIcons.COPY_TO_FOLDER, KeyBinding.COPY),
    REMOVE_LINK(Localization.lang("Remove link", new Object[0]), IconTheme.JabRefIcons.REMOVE_LINK),
    DELETE_FILE(Localization.lang("Permanently delete local file", new Object[0]), IconTheme.JabRefIcons.DELETE_FILE, KeyBinding.DELETE_ENTRY),
    HELP(Localization.lang("Online help", new Object[0]), IconTheme.JabRefIcons.HELP, KeyBinding.HELP),
    HELP_GROUPS(Localization.lang("Open Help page", new Object[0]), IconTheme.JabRefIcons.HELP, KeyBinding.HELP),
    HELP_KEY_PATTERNS(Localization.lang("Help on key patterns", new Object[0]), IconTheme.JabRefIcons.HELP, KeyBinding.HELP),
    HELP_REGEX_SEARCH(Localization.lang("Help on regular expression search", new Object[0]), IconTheme.JabRefIcons.HELP, KeyBinding.HELP),
    HELP_NAME_FORMATTER(Localization.lang("Help on Name Formatting", new Object[0]), IconTheme.JabRefIcons.HELP, KeyBinding.HELP),
    HELP_SPECIAL_FIELDS(Localization.lang("Help on special fields", new Object[0]), IconTheme.JabRefIcons.HELP, KeyBinding.HELP),
    HELP_PUSH_TO_APPLICATION(Localization.lang("Help on external applications", new Object[0]), IconTheme.JabRefIcons.HELP, KeyBinding.HELP),
    WEB_MENU(Localization.lang("JabRef resources", new Object[0])),
    OPEN_WEBPAGE(Localization.lang("Website", new Object[0]), Localization.lang("Opens JabRef's website", new Object[0]), IconTheme.JabRefIcons.HOME),
    OPEN_FACEBOOK("Facebook", Localization.lang("Opens JabRef's Facebook page", new Object[0]), IconTheme.JabRefIcons.FACEBOOK),
    OPEN_TWITTER("Twitter", Localization.lang("Opens JabRef's Twitter page", new Object[0]), IconTheme.JabRefIcons.TWITTER),
    OPEN_BLOG(Localization.lang("Blog", new Object[0]), Localization.lang("Opens JabRef's blog", new Object[0]), IconTheme.JabRefIcons.BLOG),
    OPEN_DEV_VERSION_LINK(Localization.lang("Development version", new Object[0]), Localization.lang("Opens a link where the current development version can be downloaded", new Object[0])),
    OPEN_CHANGELOG(Localization.lang("View change log", new Object[0]), Localization.lang("See what has been changed in the JabRef versions", new Object[0])),
    OPEN_GITHUB("GitHub", Localization.lang("Opens JabRef's GitHub page", new Object[0]), IconTheme.JabRefIcons.GITHUB),
    DONATE(Localization.lang("Donate to JabRef", new Object[0]), Localization.lang("Donate to JabRef", new Object[0]), IconTheme.JabRefIcons.DONATE),
    OPEN_FORUM(Localization.lang("Online help forum", new Object[0]), Localization.lang("Online help forum", new Object[0]), IconTheme.JabRefIcons.FORUM),
    ERROR_CONSOLE(Localization.lang("View event log", new Object[0]), Localization.lang("Display all error messages", new Object[0])),
    SEARCH_FOR_UPDATES(Localization.lang("Check for updates", new Object[0])),
    ABOUT(Localization.lang("About JabRef", new Object[0]), Localization.lang("About JabRef", new Object[0])),
    EDIT_LIST(Localization.lang("Edit", new Object[0]), IconTheme.JabRefIcons.EDIT),
    VIEW_LIST(Localization.lang("View", new Object[0]), IconTheme.JabRefIcons.FILE),
    REMOVE_LIST(Localization.lang("Remove", new Object[0]), IconTheme.JabRefIcons.REMOVE),
    RELOAD_LIST(Localization.lang("Reload", new Object[0]), IconTheme.JabRefIcons.REFRESH),
    GROUP_REMOVE(Localization.lang("Remove group", new Object[0])),
    GROUP_REMOVE_KEEP_SUBGROUPS(Localization.lang("Keep subgroups", new Object[0])),
    GROUP_REMOVE_WITH_SUBGROUPS(Localization.lang("Also remove subgroups", new Object[0])),
    GROUP_EDIT(Localization.lang("Edit group", new Object[0])),
    GROUP_SUBGROUP_ADD(Localization.lang("Add subgroup", new Object[0])),
    GROUP_SUBGROUP_REMOVE(Localization.lang("Remove subgroups", new Object[0])),
    GROUP_SUBGROUP_SORT(Localization.lang("Sort subgroups A-Z", new Object[0])),
    GROUP_SUBGROUP_SORT_REVERSE(Localization.lang("Sort subgroups Z-A", new Object[0])),
    GROUP_SUBGROUP_SORT_ENTRIES(Localization.lang("Sort subgroups by # of entries (Descending)", new Object[0])),
    GROUP_SUBGROUP_SORT_ENTRIES_REVERSE(Localization.lang("Sort subgroups by # of entries (Ascending)", new Object[0])),
    GROUP_ENTRIES_ADD(Localization.lang("Add selected entries to this group", new Object[0])),
    GROUP_ENTRIES_REMOVE(Localization.lang("Remove selected entries from this group", new Object[0]));

    private String text;
    private final String description;
    private final Optional<JabRefIcon> icon;
    private final Optional<KeyBinding> keyBinding;

    private StandardActions(String text) {
        this(text, "");
    }

    private StandardActions(String text, IconTheme.JabRefIcons icon) {
        this.text = text;
        this.description = "";
        this.icon = Optional.of(icon);
        this.keyBinding = Optional.empty();
    }

    private StandardActions(String text, IconTheme.JabRefIcons icon, KeyBinding keyBinding) {
        this.text = text;
        this.description = "";
        this.icon = Optional.of(icon);
        this.keyBinding = Optional.of(keyBinding);
    }

    private StandardActions(String text, String description, IconTheme.JabRefIcons icon) {
        this.text = text;
        this.description = description;
        this.icon = Optional.of(icon);
        this.keyBinding = Optional.empty();
    }

    private StandardActions(String text, String description, IconTheme.JabRefIcons icon, KeyBinding keyBinding) {
        this.text = text;
        this.description = description;
        this.icon = Optional.of(icon);
        this.keyBinding = Optional.of(keyBinding);
    }

    private StandardActions(String text, KeyBinding keyBinding) {
        this.text = text;
        this.description = "";
        this.keyBinding = Optional.of(keyBinding);
        this.icon = Optional.empty();
    }

    private StandardActions(String text, String description) {
        this.text = text;
        this.description = description;
        this.icon = Optional.empty();
        this.keyBinding = Optional.empty();
    }

    private StandardActions(String text, String description, KeyBinding keyBinding) {
        this.text = text;
        this.description = description;
        this.icon = Optional.empty();
        this.keyBinding = Optional.of(keyBinding);
    }

    @Override
    public Optional<JabRefIcon> getIcon() {
        return this.icon;
    }

    @Override
    public Optional<KeyBinding> getKeyBinding() {
        return this.keyBinding;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Action withText(String text) {
        this.text = Objects.requireNonNull(text);
        return this;
    }
}

