/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.airhacks.afterburner.injection.Injector;
import com.tobiasdiez.easybind.EasyBind;
import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.undo.UndoManager;
import kong.unirest.core.Unirest;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.FallbackExceptionHandler;
import org.jabref.gui.JabRefDialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.frame.JabRefFrame;
import org.jabref.gui.help.VersionWorker;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.keyboard.TextInputKeyBindings;
import org.jabref.gui.openoffice.OOBibBaseConnect;
import org.jabref.gui.remote.CLIMessageHandler;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.UiCommand;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.ProxyRegisterer;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.remote.server.RemoteListenerServerManager;
import org.jabref.logic.util.BuildInfo;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.logic.util.WebViewStore;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.DirectoryMonitor;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.GuiPreferences;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabRefGUI
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefGUI.class);
    private static List<UiCommand> uiCommands;
    private static JabRefPreferences preferencesService;
    private static FileUpdateMonitor fileUpdateMonitor;
    private static StateManager stateManager;
    private static ThemeManager themeManager;
    private static CountingUndoManager countingUndoManager;
    private static TaskExecutor taskExecutor;
    private static ClipBoardManager clipBoardManager;
    private static DialogService dialogService;
    private static JabRefFrame mainFrame;
    private static RemoteListenerServerManager remoteListenerServerManager;
    private boolean correctedWindowPos = false;
    private Stage mainStage;

    public static void setup(List<UiCommand> uiCommands, JabRefPreferences preferencesService, FileUpdateMonitor fileUpdateMonitor) {
        JabRefGUI.uiCommands = uiCommands;
        JabRefGUI.preferencesService = preferencesService;
        JabRefGUI.fileUpdateMonitor = fileUpdateMonitor;
    }

    public void start(Stage stage) {
        this.mainStage = stage;
        FallbackExceptionHandler.installExceptionHandler();
        this.initialize();
        mainFrame = new JabRefFrame(this.mainStage, dialogService, fileUpdateMonitor, preferencesService, stateManager, countingUndoManager, (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class), clipBoardManager, taskExecutor);
        this.openWindow();
        this.startBackgroundTasks();
        if (!fileUpdateMonitor.isActive()) {
            dialogService.showErrorDialogAndWait(Localization.lang("Unable to monitor file changes. Please close files and processes and restart. You may encounter errors if you continue with this session.", new Object[0]));
        }
        BuildInfo buildInfo = (BuildInfo)Injector.instantiateModelOrService(BuildInfo.class);
        EasyBind.subscribe((ObservableValue)preferencesService.getInternalPreferences().versionCheckEnabledProperty(), enabled -> {
            if (enabled.booleanValue()) {
                new VersionWorker(buildInfo.version, dialogService, taskExecutor, preferencesService).checkForNewVersionDelayed();
            }
        });
        this.setupProxy();
    }

    public void initialize() {
        WebViewStore.init();
        remoteListenerServerManager = new RemoteListenerServerManager();
        Injector.setModelOrService(RemoteListenerServerManager.class, (Object)remoteListenerServerManager);
        stateManager = new StateManager();
        Injector.setModelOrService(StateManager.class, (Object)stateManager);
        Injector.setModelOrService(KeyBindingRepository.class, (Object)preferencesService.getKeyBindingRepository());
        themeManager = new ThemeManager(preferencesService.getWorkspacePreferences(), fileUpdateMonitor, Runnable::run);
        Injector.setModelOrService(ThemeManager.class, (Object)themeManager);
        countingUndoManager = new CountingUndoManager();
        Injector.setModelOrService(UndoManager.class, (Object)countingUndoManager);
        Injector.setModelOrService(CountingUndoManager.class, (Object)countingUndoManager);
        taskExecutor = new UiTaskExecutor();
        Injector.setModelOrService(TaskExecutor.class, (Object)taskExecutor);
        dialogService = new JabRefDialogService((Window)this.mainStage);
        Injector.setModelOrService(DialogService.class, (Object)dialogService);
        clipBoardManager = new ClipBoardManager();
        Injector.setModelOrService(TaskExecutor.class, (Object)taskExecutor);
    }

    private void setupProxy() {
        if (!preferencesService.getProxyPreferences().shouldUseProxy() || !preferencesService.getProxyPreferences().shouldUseAuthentication()) {
            return;
        }
        if (preferencesService.getProxyPreferences().shouldPersistPassword() && StringUtil.isNotBlank(preferencesService.getProxyPreferences().getPassword())) {
            ProxyRegisterer.register(preferencesService.getProxyPreferences());
            return;
        }
        Optional<String> password = dialogService.showPasswordDialogAndWait(Localization.lang("Proxy configuration", new Object[0]), Localization.lang("Proxy requires password", new Object[0]), Localization.lang("Password", new Object[0]));
        if (password.isPresent()) {
            preferencesService.getProxyPreferences().setPassword(password.get());
            ProxyRegisterer.register(preferencesService.getProxyPreferences());
        } else {
            LOGGER.warn("No proxy password specified");
        }
    }

    private void openWindow() {
        LOGGER.debug("Initializing frame");
        GuiPreferences guiPreferences = preferencesService.getGuiPreferences();
        this.mainStage.setMinHeight(330.0);
        this.mainStage.setMinWidth(580.0);
        this.mainStage.setFullScreen(guiPreferences.isWindowFullscreen());
        this.mainStage.setMaximized(guiPreferences.isWindowMaximised());
        if (Screen.getScreens().size() == 1 && this.isWindowPositionOutOfBounds()) {
            LOGGER.debug("The Jabref window is outside the main screen");
            this.mainStage.setX(0.0);
            this.mainStage.setY(0.0);
            this.mainStage.setWidth(1024.0);
            this.mainStage.setHeight(768.0);
            this.correctedWindowPos = true;
        } else {
            this.mainStage.setX(guiPreferences.getPositionX());
            this.mainStage.setY(guiPreferences.getPositionY());
            this.mainStage.setWidth(guiPreferences.getSizeX());
            this.mainStage.setHeight(guiPreferences.getSizeY());
        }
        this.debugLogWindowState(this.mainStage);
        Scene scene = new Scene((Parent)mainFrame);
        themeManager.installCss(scene);
        scene.addEventFilter(KeyEvent.KEY_PRESSED, event -> TextInputKeyBindings.call(scene, event, preferencesService.getKeyBindingRepository()));
        this.mainStage.setTitle("JabRef");
        this.mainStage.getIcons().addAll(IconTheme.getLogoSetFX());
        this.mainStage.setScene(scene);
        this.mainStage.setOnShowing(this::onShowing);
        this.mainStage.setOnCloseRequest(this::onCloseRequest);
        this.mainStage.setOnHiding(this::onHiding);
        this.mainStage.show();
        Platform.runLater(() -> mainFrame.handleUiCommands(uiCommands));
    }

    public void onShowing(WindowEvent event) {
        Platform.runLater(() -> mainFrame.updateDividerPosition());
        if (uiCommands.stream().noneMatch(UiCommand.BlankWorkspace.class::isInstance) && preferencesService.getWorkspacePreferences().shouldOpenLastEdited()) {
            mainFrame.openLastEditedDatabases();
        }
    }

    public void onCloseRequest(WindowEvent event) {
        if (!mainFrame.close()) {
            event.consume();
        }
    }

    public void onHiding(WindowEvent event) {
        if (!this.correctedWindowPos) {
            this.saveWindowState();
        }
        preferencesService.flush();
        Platform.exit();
    }

    private void saveWindowState() {
        GuiPreferences preferences = preferencesService.getGuiPreferences();
        preferences.setPositionX(this.mainStage.getX());
        preferences.setPositionY(this.mainStage.getY());
        preferences.setSizeX(this.mainStage.getWidth());
        preferences.setSizeY(this.mainStage.getHeight());
        preferences.setWindowMaximised(this.mainStage.isMaximized());
        preferences.setWindowFullScreen(this.mainStage.isFullScreen());
        this.debugLogWindowState(this.mainStage);
    }

    private void debugLogWindowState(Stage mainStage) {
        if (LOGGER.isDebugEnabled()) {
            String debugLogString = "SCREEN DATA:mainStage.WINDOW_MAXIMISED: " + mainStage.isMaximized() + "\nmainStage.POS_X: " + mainStage.getX() + "\nmainStage.POS_Y: " + mainStage.getY() + "\nmainStage.SIZE_X: " + mainStage.getWidth() + "\nmainStages.SIZE_Y: " + mainStage.getHeight() + "\n";
            LOGGER.debug(debugLogString);
        }
    }

    private boolean isWindowPositionOutOfBounds() {
        return !Screen.getPrimary().getBounds().contains(preferencesService.getGuiPreferences().getPositionX(), preferencesService.getGuiPreferences().getPositionY());
    }

    public void startBackgroundTasks() {
        RemotePreferences remotePreferences = preferencesService.getRemotePreferences();
        BibEntryTypesManager bibEntryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
        if (remotePreferences.useRemoteServer()) {
            remoteListenerServerManager.openAndStart(new CLIMessageHandler(mainFrame, preferencesService, fileUpdateMonitor, bibEntryTypesManager), remotePreferences.getPort());
        }
    }

    public void stop() {
        OOBibBaseConnect.closeOfficeConnection();
        this.stopBackgroundTasks();
        JabRefGUI.shutdownThreadPools();
    }

    public void stopBackgroundTasks() {
        Unirest.shutDown();
    }

    public static void shutdownThreadPools() {
        taskExecutor.shutdown();
        fileUpdateMonitor.shutdown();
        DirectoryMonitor directoryMonitor = (DirectoryMonitor)Injector.instantiateModelOrService(DirectoryMonitor.class);
        directoryMonitor.shutdown();
        HeadlessExecutorService.INSTANCE.shutdownEverything();
    }
}

