/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring.internal.windows;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.PasswordAccessException;
import com.github.javakeyring.internal.KeyringBackend;
import com.github.javakeyring.internal.windows.CREDENTIAL;
import com.github.javakeyring.internal.windows.NativeLibraryManager;
import com.sun.jna.Memory;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.Charset;

public class WinCredentialStoreBackend
implements KeyringBackend {
    private final NativeLibraryManager nativeLibraries = new NativeLibraryManager();

    @Override
    public String getPassword(String service, String account) throws PasswordAccessException {
        PointerByReference ref = new PointerByReference();
        WinDef.DWORD type = new WinDef.DWORD(1L);
        WinDef.DWORD unused = new WinDef.DWORD(0L);
        Boolean success = this.nativeLibraries.getAdvapi32().CredReadA(service + "|" + account, type, unused, ref);
        if (!success.booleanValue()) {
            throw new PasswordAccessException("Error code " + this.nativeLibraries.getKernel32().GetLastError());
        }
        CREDENTIAL cred = new CREDENTIAL(ref.getValue());
        try {
            byte[] passbytes = cred.CredentialBlob.getByteArray(0L, cred.CredentialBlobSize);
            if (passbytes == null) {
                throw new PasswordAccessException("Password not Found");
            }
            String string = new String(passbytes, Charset.forName("UTF-16LE"));
            return string;
        }
        catch (Exception ex) {
            throw new PasswordAccessException(ex.getMessage());
        }
        finally {
            this.nativeLibraries.getAdvapi32().CredFree(ref.getValue());
        }
    }

    @Override
    public void setPassword(String service, String account, String password) throws PasswordAccessException {
        CREDENTIAL cred = new CREDENTIAL();
        cred.TargetName = service + "|" + account;
        cred.UserName = account;
        cred.Type = 1;
        byte[] bytes = password.getBytes(Charset.forName("UTF-16LE"));
        Boolean success = false;
        try (Memory passwordMemory = new Memory((long)bytes.length);){
            passwordMemory.write(0L, bytes, 0, bytes.length);
            cred.CredentialBlob = passwordMemory;
            cred.CredentialBlobSize = bytes.length;
            cred.Persist = 2;
            success = this.nativeLibraries.getAdvapi32().CredWriteA(cred, new WinDef.DWORD(0L));
            passwordMemory.clear();
        }
        if (!success.booleanValue()) {
            throw new PasswordAccessException("Error code " + this.nativeLibraries.getKernel32().GetLastError());
        }
    }

    @Override
    public void deletePassword(String service, String account) throws PasswordAccessException {
        boolean success = this.nativeLibraries.getAdvapi32().CredDeleteA(service + "|" + account, new WinDef.DWORD(1L), new WinDef.DWORD(0L));
        if (!success) {
            throw new PasswordAccessException("Error code " + this.nativeLibraries.getKernel32().GetLastError());
        }
    }

    @Override
    public void close() throws Exception {
    }
}

