/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLLabel;

public class CSLCitationItemBuilder {
    private String id;
    private CSLItemData itemData;
    private String prefix;
    private String suffix;
    private String locator;
    private Integer position;
    private Boolean nearNote;
    private Integer noteNumber;
    private Integer firstReferenceNoteNumber;
    private CSLLabel label;
    private Boolean suppressAuthor;
    private Boolean authorOnly;
    private String[] uris;

    public CSLCitationItemBuilder(String id) {
        this.id = id;
        this.itemData = null;
        this.prefix = null;
        this.suffix = null;
        this.locator = null;
        this.position = null;
        this.nearNote = null;
        this.noteNumber = null;
        this.firstReferenceNoteNumber = null;
        this.label = null;
        this.suppressAuthor = null;
        this.authorOnly = null;
        this.uris = null;
    }

    public CSLCitationItemBuilder itemData(CSLItemData itemData) {
        this.itemData = itemData;
        return this;
    }

    public CSLCitationItemBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public CSLCitationItemBuilder suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public CSLCitationItemBuilder locator(String locator) {
        this.locator = locator;
        return this;
    }

    public CSLCitationItemBuilder position(Integer position) {
        this.position = position;
        return this;
    }

    public CSLCitationItemBuilder nearNote(Boolean nearNote) {
        this.nearNote = nearNote;
        return this;
    }

    public CSLCitationItemBuilder noteNumber(Integer noteNumber) {
        this.noteNumber = noteNumber;
        return this;
    }

    public CSLCitationItemBuilder firstReferenceNoteNumber(Integer firstReferenceNoteNumber) {
        this.firstReferenceNoteNumber = firstReferenceNoteNumber;
        return this;
    }

    public CSLCitationItemBuilder label(CSLLabel label) {
        this.label = label;
        return this;
    }

    public CSLCitationItemBuilder suppressAuthor(Boolean suppressAuthor) {
        this.suppressAuthor = suppressAuthor;
        return this;
    }

    public CSLCitationItemBuilder authorOnly(Boolean authorOnly) {
        this.authorOnly = authorOnly;
        return this;
    }

    public CSLCitationItemBuilder uris(String ... uris) {
        this.uris = uris;
        return this;
    }

    public CSLCitationItemBuilder(CSLCitationItem original) {
        this.id = original.getId();
        this.itemData = original.getItemData();
        this.prefix = original.getPrefix();
        this.suffix = original.getSuffix();
        this.locator = original.getLocator();
        this.position = original.getPosition();
        this.nearNote = original.getNearNote();
        this.noteNumber = original.getNoteNumber();
        this.firstReferenceNoteNumber = original.getFirstReferenceNoteNumber();
        this.label = original.getLabel();
        this.suppressAuthor = original.getSuppressAuthor();
        this.authorOnly = original.getAuthorOnly();
        this.uris = original.getUris();
    }

    public CSLCitationItem build() {
        return new CSLCitationItem(this.id, this.itemData, this.prefix, this.suffix, this.locator, this.position, this.nearNote, this.noteNumber, this.firstReferenceNoteNumber, this.label, this.suppressAuthor, this.authorOnly, this.uris);
    }
}

