/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.ParagraphText;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.event.MouseStationaryHelper;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.EventStream;
import org.reactfx.util.Either;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class ParagraphBox<PS, SEG, S>
extends Region {
    private final ParagraphText<PS, SEG, S> text;
    private final ObjectProperty<IntFunction<? extends Node>> graphicFactory = new SimpleObjectProperty(null);
    private final Val<Node> graphic;
    final DoubleProperty graphicOffset = new SimpleDoubleProperty(0.0);
    private final BooleanProperty wrapText = new SimpleBooleanProperty(false);
    private final Val<Boolean> isFolded;
    private final Var<Integer> index;

    public ObjectProperty<IntFunction<? extends Node>> graphicFactoryProperty() {
        return this.graphicFactory;
    }

    public BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public boolean isFolded() {
        return (Boolean)this.isFolded.getValue();
    }

    public Val<Integer> indexProperty() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index.setValue((Object)index);
    }

    public int getIndex() {
        return (Integer)this.index.getValue();
    }

    public final ObservableSet<CaretNode> caretsProperty() {
        return this.text.caretsProperty();
    }

    public final ObservableMap<Selection<PS, SEG, S>, SelectionPath> selectionsProperty() {
        return this.text.selectionsProperty();
    }

    ParagraphBox(Paragraph<PS, SEG, S> par, BiConsumer<TextFlow, PS> applyParagraphStyle, Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        this.wrapText.addListener((obs, old, w) -> this.requestLayout());
        this.getStyleClass().add((Object)"paragraph-box");
        this.text = new ParagraphText<PS, SEG, S>(par, nodeFactory);
        applyParagraphStyle.accept(this.text, par.getParagraphStyle());
        this.isFolded = Val.wrap((ObservableValue)this.text.visibleProperty().not());
        this.index = Var.newSimpleVar((Object)-1);
        this.getChildren().add(this.text);
        this.graphic = Val.combine(this.graphicFactory, this.index, (f, i) -> f != null && i > -1 ? (Node)f.apply((int)i) : null);
        this.graphic.addListener((obs, oldG, newG) -> {
            if (oldG != null) {
                this.getChildren().remove(oldG);
            }
            if (newG != null) {
                this.getChildren().add(newG);
            }
        });
        this.graphicOffset.addListener(obs -> this.requestLayout());
    }

    void dispose() {
        this.text.dispose();
    }

    public String toString() {
        return String.format("ParagraphBox@%s[%s|%s]", ((Object)((Object)this)).hashCode(), this.graphic.isPresent() ? "#" : "", this.text.getParagraph());
    }

    public Property<Paint> highlightTextFillProperty() {
        return this.text.highlightTextFillProperty();
    }

    Paragraph<PS, SEG, S> getParagraph() {
        return this.text.getParagraph();
    }

    Node getGraphic() {
        if (this.graphic.isPresent()) {
            return (Node)this.graphic.getValue();
        }
        return null;
    }

    public EventStream<Either<Tuple2<Point2D, Integer>, Object>> stationaryIndices(Duration delay) {
        EventStream<Either<Point2D, Void>> stationaryEvents = new MouseStationaryHelper((Node)this).events(delay);
        EventStream hits = stationaryEvents.filterMap(Either::asLeft).filterMap(p -> {
            OptionalInt charIdx = this.hit((Point2D)p).getCharacterIndex();
            if (charIdx.isPresent()) {
                return Optional.of(Tuples.t((Object)p, (Object)charIdx.getAsInt()));
            }
            return Optional.empty();
        });
        EventStream stops = stationaryEvents.filter(Either::isRight).map(Either::getRight);
        return hits.or(stops);
    }

    public CharacterHit hit(Point2D pos) {
        return this.hit(pos.getX(), pos.getY());
    }

    public CharacterHit hit(double x, double y) {
        Point2D onScreen = this.localToScreen(x, y);
        Point2D inText = this.text.screenToLocal(onScreen);
        Insets textInsets = this.text.getInsets();
        return this.text.hit(inText.getX() - textInsets.getLeft(), inText.getY() - textInsets.getTop());
    }

    public <T extends Node> CaretOffsetX getCaretOffsetX(T caret) {
        this.layout();
        return new CaretOffsetX(this.text.getCaretOffsetX(caret));
    }

    public int getCurrentLineStartPosition(Caret caret) {
        this.layout();
        return this.text.getCurrentLineStartPosition(caret);
    }

    public int getCurrentLineEndPosition(Caret caret) {
        this.layout();
        return this.text.getCurrentLineEndPosition(caret);
    }

    public int getLineCount() {
        this.layout();
        return this.text.getLineCount();
    }

    public int getCurrentLineIndex(Caret caret) {
        this.layout();
        return this.text.currentLineIndex(caret);
    }

    public int getCurrentLineIndex(int position) {
        this.layout();
        return this.text.currentLineIndex(position);
    }

    public <T extends Node> Bounds getCaretBounds(T caret) {
        this.layout();
        Bounds b = this.text.getCaretBounds(caret);
        return this.text.localToParent(b);
    }

    public <T extends Node> Bounds getCaretBoundsOnScreen(T caret) {
        this.layout();
        return this.text.getCaretBoundsOnScreen(caret);
    }

    public Optional<Bounds> getSelectionBoundsOnScreen(Selection<PS, SEG, S> selection) {
        this.layout();
        return this.text.getSelectionBoundsOnScreen(selection);
    }

    public Bounds getRangeBoundsOnScreen(int from, int to) {
        this.layout();
        return this.text.getRangeBoundsOnScreen(from, to);
    }

    protected double computeMinWidth(double ignoredHeight) {
        return this.computePrefWidth(-1.0);
    }

    protected double computePrefWidth(double ignoredHeight) {
        Insets insets = this.getInsets();
        return this.wrapText.get() ? 0.0 : this.getGraphicPrefWidth() + this.text.prefWidth(-1.0) + insets.getLeft() + insets.getRight();
    }

    protected double computePrefHeight(double width) {
        if (((Boolean)this.isFolded.getValue()).booleanValue()) {
            return 0.0;
        }
        if (!this.wrapText.get()) {
            width = Double.MAX_VALUE;
        }
        Insets insets = this.getInsets();
        double overhead = this.getGraphicPrefWidth() + insets.getLeft() + insets.getRight();
        return this.text.prefHeight(width - overhead) + insets.getTop() + insets.getBottom() + this.text.getLineSpacing();
    }

    protected void layoutChildren() {
        Insets ins = this.getInsets();
        double h = this.getHeight() - ins.getTop() - ins.getBottom();
        double graphicWidth = this.getGraphicPrefWidth();
        if (this.wrapText.get()) {
            double half = this.text.getLineSpacing() / 2.0;
            double w = this.getWidth() - ins.getLeft() - ins.getRight();
            this.text.resizeRelocate(graphicWidth + ins.getLeft(), ins.getTop() + half, w - graphicWidth, h - half);
        } else {
            this.text.relocate(graphicWidth + ins.getLeft(), ins.getTop());
            this.text.autosize();
        }
        this.graphic.filter(Node::isManaged).ifPresent(g -> g.resizeRelocate(this.graphicOffset.get() + ins.getLeft(), ins.getTop(), graphicWidth, h));
    }

    double getGraphicPrefWidth() {
        return (Double)this.graphic.filter(Node::isManaged).map(n -> Math.min(Math.max(n.prefWidth(-1.0), n.minWidth(-1.0)), n.maxWidth(-1.0))).getOrElse((Object)0.0);
    }

    CharacterHit hitTextLine(CaretOffsetX x, int line) {
        return this.text.hitLine(x.value, line);
    }

    CharacterHit hitText(CaretOffsetX x, double y) {
        return this.text.hit(x.value, y);
    }

    public static class CaretOffsetX {
        private final double value;

        private CaretOffsetX(double value) {
            this.value = value;
        }
    }
}

