/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.SerializationMethod;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;

public final class WebPageOutputOptionsBuilder {
    public static final WebPageOutputOptions createXHTMLMathJaxOptions() {
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setSerializationMethod(SerializationMethod.XHTML);
        options.setIncludingXMLDeclaration(false);
        options.setMathJax(true);
        return options;
    }

    public static final WebPageOutputOptions createXHTMLMathJaxOptions(String customMathJaxUrl) {
        WebPageOutputOptions options = WebPageOutputOptionsBuilder.createXHTMLMathJaxOptions();
        options.setCustomMathJaxUrl(customMathJaxUrl);
        return options;
    }

    public static final WebPageOutputOptions createHTML5MathJaxOptions() {
        WebPageOutputOptions options = WebPageOutputOptionsBuilder.createHTML5Options();
        options.setMathJax(true);
        return options;
    }

    public static final WebPageOutputOptions createHTML5MathJaxOptions(String customMathJaxUrl) {
        WebPageOutputOptions options = WebPageOutputOptionsBuilder.createHTML5MathJaxOptions();
        options.setCustomMathJaxUrl(customMathJaxUrl);
        return options;
    }

    public static final WebPageOutputOptions createMozillaSpecificOptions() {
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setMathJax(false);
        options.setSerializationMethod(SerializationMethod.XHTML);
        options.setIncludingXMLDeclaration(false);
        options.setContentType("application/xhtml+xml");
        return options;
    }

    public static final WebPageOutputOptions createIEMathPlayerSpecificOptions() {
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setSerializationMethod(SerializationMethod.HTML);
        options.setContentType("text/html");
        options.setPrefixingMathML(true);
        options.setAddingMathPlayerImport(true);
        return options;
    }

    public static final WebPageOutputOptions createUniversalStylesheetOptions(String clientStylesheetUrl) {
        return WebPageOutputOptionsBuilder.createUniversalStylesheetOptions(clientStylesheetUrl, "mathplayer-dl");
    }

    public static final WebPageOutputOptions createUniversalStylesheetOptions(String clientStylesheetUrl, String rendererPreference) {
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setSerializationMethod(SerializationMethod.XML);
        options.setIncludingXMLDeclaration(true);
        options.setMathPrefRenderer(rendererPreference);
        options.setClientSideXSLTStylesheetURLs(clientStylesheetUrl);
        return options;
    }

    public static final WebPageOutputOptions createLegacyCrossBrowserOptions() {
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setMathJax(false);
        options.setSerializationMethod(SerializationMethod.XHTML);
        options.setIncludingXMLDeclaration(true);
        options.setContentType("application/xhtml+xml");
        options.setNoCharsetInContentTypeHeader(true);
        options.setXHTMLPrefix("");
        options.setMathMLPrefix("");
        options.setDoctypePublic("-//W3C//DTD XHTML 1.1 plus MathML 2.0//EN");
        options.setDoctypeSystem("http://www.w3.org/Math/DTD/mathml2/xhtml-math11-f.dtd");
        return options;
    }

    public static final WebPageOutputOptions createXHTMLOptions() {
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setSerializationMethod(SerializationMethod.XHTML);
        return options;
    }

    public static final WebPageOutputOptions createHTML4Options() {
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setSerializationMethod(SerializationMethod.HTML);
        return options;
    }

    public static final WebPageOutputOptions createHTML5Options() {
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setSerializationMethod(SerializationMethod.STRICTLY_HTML);
        options.setErrorOutputOptions(DOMOutputOptions.ErrorOutputOptions.XHTML);
        options.setHtml5(true);
        return options;
    }
}

