/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.commands;

import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.commands.CommandBase;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class CompositeCommand
extends CommandBase {
    private final ObservableList<Command> registeredCommands = FXCollections.observableArrayList();
    ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper();

    public CompositeCommand(Command ... commands) {
        this.initRegisteredCommandsListener();
        this.registeredCommands.addAll((Object[])commands);
    }

    public void register(Command command) {
        this.registeredCommands.add((Object)command);
    }

    public void unregister(Command command) {
        this.registeredCommands.remove((Object)command);
    }

    private void initRegisteredCommandsListener() {
        this.registeredCommands.addListener(c -> {
            while (c.next()) {
                if (this.registeredCommands.isEmpty()) {
                    this.executable.unbind();
                    this.running.unbind();
                    this.progress.unbind();
                    continue;
                }
                BooleanBinding executableBinding = this.constantOf(true);
                BooleanBinding runningBinding = this.constantOf(false);
                for (Command registeredCommand : this.registeredCommands) {
                    ReadOnlyBooleanProperty currentExecutable = registeredCommand.executableProperty();
                    ReadOnlyBooleanProperty currentRunning = registeredCommand.runningProperty();
                    executableBinding = executableBinding.and((ObservableBooleanValue)currentExecutable);
                    runningBinding = runningBinding.or((ObservableBooleanValue)currentRunning);
                }
                this.executable.bind((ObservableValue)executableBinding);
                this.running.bind((ObservableValue)runningBinding);
                this.initProgressBinding();
            }
        });
    }

    private void initProgressBinding() {
        DoubleBinding tmp = this.constantOf(0.0);
        for (Command command : this.registeredCommands) {
            ReadOnlyDoubleProperty progressProperty = command.progressProperty();
            DoubleBinding normalizedProgress = Bindings.createDoubleBinding(() -> progressProperty.get() == -1.0 ? 0.0 : progressProperty.get(), (Observable[])new Observable[]{progressProperty});
            tmp = tmp.add((ObservableNumberValue)normalizedProgress);
        }
        int divisor = this.registeredCommands.isEmpty() ? 1 : this.registeredCommands.size();
        this.progress.bind((ObservableValue)Bindings.divide((ObservableNumberValue)tmp, (int)divisor));
    }

    @Override
    public void execute() {
        if (!this.isExecutable()) {
            throw new RuntimeException("Not executable");
        }
        if (!this.registeredCommands.isEmpty()) {
            this.registeredCommands.forEach(t -> t.execute());
        }
    }

    @Override
    public double getProgress() {
        return this.progressProperty().get();
    }

    @Override
    public ReadOnlyDoubleProperty progressProperty() {
        return this.progress;
    }

    private BooleanBinding constantOf(final boolean defaultValue) {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return defaultValue;
            }
        };
    }

    private DoubleBinding constantOf(final double defaultValue) {
        return new DoubleBinding(){

            protected double computeValue() {
                return defaultValue;
            }
        };
    }
}

